/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base;

import filenet.vw.base.JVMSystemConstants;
import filenet.vw.base.VWAuthItem;
import filenet.vw.base.VWCapsuleAES;
import filenet.vw.base.VWConvertCache;
import filenet.vw.base.util.Base64;
import filenet.vw.base.util.Crypto;
import filenet.vw.base.util.UTF8Helper;
import java.io.FileInputStream;
import java.security.Key;
import java.security.KeyStore;

public final class VWConvertAES {
    private String alias = null;
    private char[] s = new char[]{'+', '-'};
    private char[] v = new char[]{'1', 'a'};
    private byte[] encodedKey = null;
    private static String helpString = "  If a different private key is needed, then need to make sure the following is done:\n  \n  1.  Use the JRE (the one that will run the client)'s keytool to generate\n  a key.  Something like this:\n  \n  keytool -genseckey -v -alias JPESECRETALIAS -keyalg AES -keysize 128 \n  \t\t\t-keypass JPEKEYPW -keystore JPEKEYSTORE -storepass JPEKEYPW -storetype JCEKS\n\nTo list the key: \n\tkeytool -list -storetype JCEKS -keystore JPEKEYSTORE -keypass JPEKEYPW\n\n2. Add the following to the client application JRE/lib/p8bpmsystems.properties\n\nfilenet.pe.encryption.keystore.path=<fully qualified>JPEKEYSTORE\nfilenet.pe.encryption.keystore.pw=JPEKEYPW\nfilenet.pe.encryption.keystore.keypw=JPEKEYPW\nfilenet.pe.encryption.keystore.keyalias=JPESECRETALIAS\n\n3.  Use the ClientGenSeed as follows:\n\nClientGenSeed name pw JPESECRETALIAS\n\n(replace the JPEXXX with the desired values)\n\nSome example:\njava -cp classes filenet.vw.base.util.ClientGenSeed myname mypw JPESECRETALIAS\n!v2!JPESECRETALIAS!v2!i421VjsSvNkajk2ewCuZtL79YMS7Un9zfPukRsRe6ng=\n\n\nthen the whole value, \n!v2!JPESECRETALIAS!v2!i421VjsSvNkajk2ewCuZtL79YMS7Un9zfPukRsRe6ng=\ncan be used as the encrypted name/pw where needed.\nFor example, Component Manager, the P8BPMWSBroker servlet?.\n\nWARNING: must use the same JRE!!\n";

    public VWConvertAES() {
        this.alias = JVMSystemConstants.GetPrivilegedSystemProperty("filenet.pe.encryption.keystore.keyalias");
        this.encodedKey = VWConvertAES.getKeyFromAlias(this.alias);
    }

    public VWConvertAES(byte[] encodedKey) {
        this.encodedKey = encodedKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static byte[] getKeyFromAlias(String alias) {
        byte[] byArray;
        String keyPw;
        String keystorePw;
        FileInputStream inStream;
        byte[] def;
        block25: {
            Key k;
            block23: {
                byte[] byArray2;
                block24: {
                    String keystorePath;
                    block21: {
                        byte[] byArray3;
                        block22: {
                            block19: {
                                byte[] byArray4;
                                block20: {
                                    block17: {
                                        byte[] byArray5;
                                        block18: {
                                            def = VWConvertCache.getVector();
                                            if (alias == null) {
                                                return def;
                                            }
                                            inStream = null;
                                            keystorePw = null;
                                            keyPw = null;
                                            keystorePath = JVMSystemConstants.GetPrivilegedSystemProperty("filenet.pe.encryption.keystore.path");
                                            if (keystorePath != null) break block17;
                                            byArray5 = def;
                                            Object var10_11 = null;
                                            keystorePw = null;
                                            keyPw = null;
                                            if (inStream == null) break block18;
                                            try {
                                                inStream.close();
                                            }
                                            catch (Exception e) {
                                                // empty catch block
                                            }
                                        }
                                        return byArray5;
                                    }
                                    keystorePw = JVMSystemConstants.GetPrivilegedSystemProperty("filenet.pe.encryption.keystore.pw");
                                    if (keystorePw != null) break block19;
                                    byArray4 = def;
                                    Object var10_12 = null;
                                    keystorePw = null;
                                    keyPw = null;
                                    if (inStream == null) break block20;
                                    try {
                                        inStream.close();
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                }
                                return byArray4;
                            }
                            keyPw = JVMSystemConstants.GetPrivilegedSystemPropertyWithDefault("filenet.pe.encryption.keystore.keypw", keystorePw);
                            if (keyPw != null) break block21;
                            byArray3 = def;
                            Object var10_13 = null;
                            keystorePw = null;
                            keyPw = null;
                            if (inStream == null) break block22;
                            try {
                                inStream.close();
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        return byArray3;
                    }
                    inStream = new FileInputStream(keystorePath);
                    KeyStore keystore = KeyStore.getInstance("JCEKS");
                    keystore.load(inStream, keystorePw.toCharArray());
                    k = keystore.getKey(alias, keyPw.toCharArray());
                    if (k != null) break block23;
                    byArray2 = def;
                    Object var10_14 = null;
                    keystorePw = null;
                    keyPw = null;
                    if (inStream == null) break block24;
                    try {
                        inStream.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                return byArray2;
            }
            byArray = k.getEncoded();
            Object var10_15 = null;
            keystorePw = null;
            keyPw = null;
            if (inStream == null) break block25;
            try {
                inStream.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return byArray;
        catch (Throwable t) {
            byte[] byArray6;
            block26: {
                try {
                    byArray6 = def;
                    Object var10_16 = null;
                    keystorePw = null;
                    keyPw = null;
                    if (inStream == null) break block26;
                }
                catch (Throwable throwable) {
                    block27: {
                        Object var10_17 = null;
                        keystorePw = null;
                        keyPw = null;
                        if (inStream == null) break block27;
                        try {
                            inStream.close();
                        }
                        catch (Exception e) {}
                    }
                    throw throwable;
                }
                try {
                    inStream.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return byArray6;
        }
    }

    public VWConvertAES(String alias) {
        this.alias = alias;
        this.encodedKey = VWConvertAES.getKeyFromAlias(alias);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEString(String value1, String value2) throws Exception {
        int n2;
        String string;
        block8: {
            if (value1 != null && value2 != null) break block8;
            String string2 = null;
            Object var19_5 = null;
            int n2 = this.encodedKey == null ? 0 : this.encodedKey.length;
            for (int i = 0; i < n2; ++i) {
                this.encodedKey[i] = 0;
            }
            return string2;
        }
        try {
            String encStr;
            byte[] value1UTF8Bytes = value1.getBytes("UTF-8");
            byte[] value2UTF8Bytes = value2.getBytes("UTF-8");
            String value2UTF8BytesLenS = Integer.toString(value2UTF8Bytes.length);
            int value2UTF8BytesLen = value2UTF8BytesLenS.length();
            int len = value1UTF8Bytes.length + value2UTF8Bytes.length + value2UTF8BytesLen + 10;
            byte[] result = new byte[len];
            int index = 0;
            result[index++] = (byte)this.v[(int)(Math.random() * 2.0)];
            System.arraycopy(value2UTF8BytesLenS.getBytes(), 0, result, index, value2UTF8BytesLen);
            index += value2UTF8BytesLen;
            result[index++] = (byte)this.s[(int)(Math.random() * 2.0)];
            int tmpIndex = value1UTF8Bytes.length - 1;
            for (int i = 0; i < value2UTF8Bytes.length; ++i) {
                result[index++] = value2UTF8Bytes[i];
                if (tmpIndex < 0) continue;
                result[index++] = value1UTF8Bytes[tmpIndex--];
            }
            while (tmpIndex >= 0) {
                result[index++] = value1UTF8Bytes[tmpIndex--];
            }
            result[index++] = (byte)this.s[(int)(Math.random() * 2.0)];
            long checksum = this.checkSumFromBytes(result, 0, index - 1);
            String checkSumS = Long.toString(checksum);
            int checkSumSLen = checkSumS.length();
            System.arraycopy(checkSumS.getBytes(), 0, result, index, checkSumSLen);
            index += checkSumSLen;
            String s2 = VWConvertAES.encode(result, this.encodedKey);
            string = encStr = VWCapsuleAES.versionDelimeter + (this.alias != null ? this.alias + VWCapsuleAES.versionDelimeter : "") + s2;
            Object var19_6 = null;
            n2 = this.encodedKey == null ? 0 : this.encodedKey.length;
        }
        catch (Throwable throwable) {
            Object var19_7 = null;
            int n2 = this.encodedKey == null ? 0 : this.encodedKey.length;
            for (int i = 0; i < n2; ++i) {
                this.encodedKey[i] = 0;
            }
            throw throwable;
        }
        for (int i = 0; i < n2; ++i) {
            this.encodedKey[i] = 0;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VWAuthItem getDString(String token) throws Exception {
        int n2;
        VWAuthItem vWAuthItem;
        int nNamePassSize;
        int i;
        byte[] decodeBytes;
        int nPassSize;
        int firstSepIndex;
        block40: {
            int lastSepIndex;
            block39: {
                int len;
                block38: {
                    long nCheckSum;
                    block37: {
                        block36: {
                            block35: {
                                int j;
                                block34: {
                                    nCheckSum = 0L;
                                    lastSepIndex = -1;
                                    firstSepIndex = 0;
                                    nPassSize = 0;
                                    if (token != null && token.length() > 0) break block34;
                                    VWAuthItem vWAuthItem2 = null;
                                    Object var28_8 = null;
                                    int n2 = this.encodedKey == null ? 0 : this.encodedKey.length;
                                    for (int i2 = 0; i2 < n2; ++i2) {
                                        this.encodedKey[i2] = 0;
                                    }
                                    return vWAuthItem2;
                                }
                                String workingData = token;
                                if (token.startsWith(VWCapsuleAES.versionDelimeter) && (j = (workingData = token.substring(VWCapsuleAES.versionDelimiterLength)).indexOf(VWCapsuleAES.versionDelimeter)) != -1) {
                                    this.alias = workingData.substring(0, j);
                                    workingData = workingData.substring(this.alias.length() + VWCapsuleAES.versionDelimiterLength);
                                    if (this.alias != null && this.alias.length() > 0) {
                                        this.encodedKey = VWConvertAES.getKeyFromAlias(this.alias);
                                    }
                                }
                                if ((decodeBytes = VWConvertAES.decode(workingData, this.encodedKey)) != null) break block35;
                                VWAuthItem vWAuthItem3 = null;
                                Object var28_9 = null;
                                int n2 = this.encodedKey == null ? 0 : this.encodedKey.length;
                                for (int i2 = 0; i2 < n2; ++i2) {
                                    this.encodedKey[i2] = 0;
                                }
                                return vWAuthItem3;
                            }
                            len = decodeBytes.length;
                            byte ver = decodeBytes[0];
                            if (ver == this.v[0] || ver == this.v[1]) break block36;
                            VWAuthItem vWAuthItem4 = null;
                            Object var28_10 = null;
                            int n2 = this.encodedKey == null ? 0 : this.encodedKey.length;
                            for (int i2 = 0; i2 < n2; ++i2) {
                                this.encodedKey[i2] = 0;
                            }
                            return vWAuthItem4;
                        }
                        for (i = len - 1; i >= 0; --i) {
                            if (decodeBytes[i] != this.s[0] && decodeBytes[i] != this.s[1]) continue;
                            lastSepIndex = i;
                            break;
                        }
                        if (lastSepIndex != -1) break block37;
                        VWAuthItem vWAuthItem5 = null;
                        Object var28_11 = null;
                        int n2 = this.encodedKey == null ? 0 : this.encodedKey.length;
                        for (int i2 = 0; i2 < n2; ++i2) {
                            this.encodedKey[i2] = 0;
                        }
                        return vWAuthItem5;
                    }
                    for (i = len - 1; i > lastSepIndex && decodeBytes[i] == 0; --i) {
                    }
                    int nCheckSumChars = i - lastSepIndex;
                    byte[] bCheckSum = new byte[nCheckSumChars];
                    System.arraycopy(decodeBytes, lastSepIndex + 1, bCheckSum, 0, nCheckSumChars);
                    String sCheckSum = new String(bCheckSum);
                    try {
                        nCheckSum = Long.parseLong(sCheckSum);
                    }
                    catch (NumberFormatException e) {
                        VWAuthItem vWAuthItem6 = null;
                        Object var28_12 = null;
                        int n2 = this.encodedKey == null ? 0 : this.encodedKey.length;
                        for (int i2 = 0; i2 < n2; ++i2) {
                            this.encodedKey[i2] = 0;
                        }
                        return vWAuthItem6;
                    }
                    if (nCheckSum == this.checkSumFromBytes(decodeBytes, 0, lastSepIndex)) break block38;
                    VWAuthItem e = null;
                    Object var28_13 = null;
                    int n2 = this.encodedKey == null ? 0 : this.encodedKey.length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        this.encodedKey[i2] = 0;
                    }
                    return e;
                }
                for (i = 0; i < len; ++i) {
                    if (decodeBytes[i] != this.s[0] && decodeBytes[i] != this.s[1]) continue;
                    firstSepIndex = i;
                    break;
                }
                if (firstSepIndex != -1) break block39;
                VWAuthItem e = null;
                Object var28_14 = null;
                int n2 = this.encodedKey == null ? 0 : this.encodedKey.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.encodedKey[i2] = 0;
                }
                return e;
            }
            byte[] bPWLen = new byte[firstSepIndex - 1];
            System.arraycopy(decodeBytes, 1, bPWLen, 0, firstSepIndex - 1);
            String sPWLen = new String(bPWLen);
            try {
                nPassSize = Integer.parseInt(sPWLen);
            }
            catch (NumberFormatException e) {
                VWAuthItem vWAuthItem7 = null;
                Object var28_15 = null;
                int n2 = this.encodedKey == null ? 0 : this.encodedKey.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.encodedKey[i2] = 0;
                }
                return vWAuthItem7;
            }
            nNamePassSize = lastSepIndex - firstSepIndex - 1;
            if (nNamePassSize >= nPassSize) break block40;
            VWAuthItem vWAuthItem8 = null;
            Object var28_16 = null;
            int n2 = this.encodedKey == null ? 0 : this.encodedKey.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.encodedKey[i2] = 0;
            }
            return vWAuthItem8;
        }
        try {
            byte[] namePassBytes = new byte[nNamePassSize];
            System.arraycopy(decodeBytes, firstSepIndex + 1, namePassBytes, 0, nNamePassSize);
            int nNameSize = nNamePassSize - nPassSize;
            byte[] nameArr = new byte[nNameSize];
            byte[] passArr = new byte[nPassSize];
            int tmpIndex = 0;
            for (i = 0; i < nPassSize; ++i) {
                passArr[i] = namePassBytes[tmpIndex++];
                if (i >= nNameSize) continue;
                nameArr[i] = namePassBytes[tmpIndex++];
            }
            while (i < nNameSize) {
                nameArr[i++] = namePassBytes[tmpIndex++];
            }
            String password = UTF8Helper.decodeString(passArr);
            byte[] tmpArr = new byte[nNameSize];
            tmpIndex = nNameSize - 1;
            for (i = 0; i < nNameSize; ++i) {
                tmpArr[i] = nameArr[tmpIndex--];
            }
            String name = UTF8Helper.decodeString(tmpArr);
            vWAuthItem = new VWAuthItem(name, password);
            Object var28_17 = null;
            n2 = this.encodedKey == null ? 0 : this.encodedKey.length;
        }
        catch (Throwable throwable) {
            Object var28_18 = null;
            int n2 = this.encodedKey == null ? 0 : this.encodedKey.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.encodedKey[i2] = 0;
            }
            throw throwable;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.encodedKey[i2] = 0;
        }
        return vWAuthItem;
    }

    private static String encode(byte[] data, byte[] encodedKey) throws Exception {
        String transform = VWConvertCache.getDesc();
        byte[] cipherText = Crypto.encryptBytes(transform, encodedKey, data);
        String sBase64Encoded = Base64.encode(cipherText);
        return sBase64Encoded;
    }

    private static byte[] decode(String data, byte[] encodedKey) throws Exception {
        String transform = VWConvertCache.getDesc();
        byte[] sBase64Decoded = Base64.decode(data);
        byte[] plainText = Crypto.decryptBytes(transform, encodedKey, sBase64Decoded);
        return plainText;
    }

    private long checksum(String s) {
        long a = 0L;
        long b = 0L;
        if (s != null) {
            for (int i = 0; i < s.length(); ++i) {
                a = (a + (long)s.charAt(i)) % 255L;
                b = (a + b) % 255L;
            }
        }
        return a * 256L + b;
    }

    private long checkSumFromBytes(byte[] s, int begin, int end) {
        long a = 0L;
        long b = 0L;
        long c = 0L;
        if (s != null) {
            for (int i = begin; i <= end; ++i) {
                c = (long)s[i] & 0xFFL;
                a = (a + c) % 255L;
                b = (a + b) % 255L;
            }
        }
        c = a * 256L + b;
        return c;
    }

    public static void main(String[] args) {
        System.err.println(helpString);
    }
}

